import xbmcplugin
import xbmcgui
import resources.lib.api as api
import resources.lib.utils as utils
from resources.lib.translation import _


@api.on_error(lambda r: r.redirect('root', 'index'))
def index(router, params):
    handle = router.session.handle
    limit = utils.addon.getSettingInt('page_limit')
    offset = params.get('offset', 0)
    hide_unavailable = utils.addon.getSettingBool('hide_unavailable')

    if hide_unavailable:
        resp = api.serials_available(router.session.token['token'], limit, offset)
    else:
        resp = api.serials(router.session.token['token'], limit, offset)

    serials = []
    for srl in resp['serials']:
        if hide_unavailable and not srl['available']:
            continue
        li = xbmcgui.ListItem(label=srl['title'], label2=srl['description'])
        li.setArt({'poster': api.art_url(srl['poster_id'])})
        if srl['fanart_id']:
            li.setArt({'fanart': api.art_url(srl['fanart_id'], 630, 354)})
        infotag = li.getVideoInfoTag()
        infotag.setTitle(srl['title'])
        infotag.setPlot(srl['description'])
        url = router.serials_url('seasons', id=srl['id'], serials_offset=offset)
        serials.append((url, li, True))

    # Next page
    if resp['offset'] < resp['total']:
        label = _('li.next_page_left') % (resp['total'] - resp['offset'])
        li = xbmcgui.ListItem(label=label)
        url = router.serials_url('index', offset=resp['offset'])
        serials.append((url, li, True))

    xbmcplugin.addDirectoryItems(handle, serials, len(serials))
    xbmcplugin.endOfDirectory(handle, updateListing=router.session.is_redirect)
    xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_TITLE)


@api.on_error(lambda r, p: r.redirect('serials', 'index', offset=p['serials_offset']))
def seasons(router, params):
    handle = router.session.handle

    resp = api.seasons(router.session.token['token'], params['id'])
    items = []
    for sn in resp['seasons']:
        li = xbmcgui.ListItem(label=sn['title'], label2=sn['description'])
        li.setArt({'poster': api.art_url(sn['poster_id'])})
        infotag = li.getVideoInfoTag()
        infotag.setTitle(sn['title'])
        infotag.setPlot(sn['description'])
        infotag.setTrackNumber(sn['number'])
        url = router.serials_url('episodes', id=sn['id'], serial_id=params['id'])
        items.append((url, li, True))

    xbmcplugin.addDirectoryItems(handle, items, len(items))
    xbmcplugin.endOfDirectory(handle, updateListing=router.session.is_redirect)
    xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_TRACKNUM)
    xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_TITLE)


@api.on_error(lambda r, p: r.redirect('serials', 'seasons', id=p['serial_id']))
def episodes(router, params):
    handle = router.session.handle

    resp = api.episodes(router.session.token['token'], params['id'])
    items = []
    for epd in resp['episodes']:
        li = xbmcgui.ListItem(label=epd['title'], label2=epd['description'])
        if epd['poster_id']:
            li.setArt({'poster': api.art_url(epd['poster_id'])})
        infotag = li.getVideoInfoTag()
        infotag.setTitle(epd['title'])
        infotag.setPlot(epd['description'])
        infotag.setTrackNumber(epd['number'])
        li.setProperty('IsPlayable', 'true')
        url = router.root_url('play', id=epd['id'], hls_id=epd['hls_id'])
        items.append((url, li, False))

    xbmcplugin.addDirectoryItems(handle, items, len(items))
    xbmcplugin.endOfDirectory(handle)
    xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_TRACKNUM)
    xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_TITLE)
