import json
import resources.lib.utils as utils
import resources.lib.api as api

def update_token_expire():
    token = utils.read_token()
    if token:
        utils.log('get a new token')
        token_new = api.token_refresh(token['token'])
        token['expires'] = token_new['expires']
        token['token']   = token_new['token']
        utils.write_file('token.json', token)
        owner = utils.update_token_info(token['token'])
        if token['is_bound']:
            if utils.addon.getSettingBool('debug_logging'):
                dev = api.devices(token['token'])
                utils.write_file('devices_' + owner + '.txt', json.dumps(dev,indent=4).encode('utf-8').decode('unicode-escape'))

