# coding: utf-8
# Module: server
# License: GPL v.3 https://www.gnu.org/copyleft/gpl.html
import threading
quit_event = threading.Event()

import sys, os, json
import xbmc, xbmcgui, xbmcaddon, xbmcvfs
import time
import gzip
#import urllib2
#import errno

if sys.version_info.major > 2:  # Python 3 or later
	import socketserver as SocketServer
	import http.server as BaseHTTPServer
	

	import urllib.request
	from urllib.parse import quote
	from urllib.parse import unquote
	import urllib.request as urllib2
	from urllib.parse import urlencode
else:  # Python 2
	from BaseHTTPServer import BaseHTTPRequestHandler,HTTPServer
	import BaseHTTPServer, SocketServer
	import urllib, urlparse
	from urllib import quote
	from urllib import unquote_plus as unquote
	import urllib2
	from urllib import urlencode

#import pztv
#pztv.update_DBC()

__settings__ = xbmcaddon.Addon(id='plugin.video.pazl.lt')
port = int(__settings__.getSetting("serv_port"))

addon = xbmcaddon.Addon(id='plugin.video.pazl.lt')
pazl = xbmcaddon.Addon(id='plugin.video.pazl.lt')
sys.path.append(pazl.getAddonInfo('path'))

def xt(x):
	try: r = xbmc.translatePath(x)
	except: r = xbmcvfs.translatePath(x)
	return r

UserDir = xt(os.path.join(xt("special://masterprofile/"),"addon_data","plugin.video.pazl.lt"))

#import cookielib
#sid_file = os.path.join(xt('special://temp/'), 'vsetv.sid')
#cj = cookielib.FileCookieJar(sid_file) 
#hr  = urllib2.HTTPCookieProcessor(cj) 
#opener = urllib2.build_opener(hr) 
#urllib2.install_opener(opener) 

def abortRequested():
	if sys.version_info.major > 2: return xbmc.Monitor().abortRequested()
	else: return xbmc.abortRequested


try: 
	from DBcnl import *
except: 
	DBC={}

try: 
	from EPGdb import *
	if EPG == "": EPG = {}
except:
	EPG = {}

#from cpdb import *

PICONS = {}


icon=None
pDialog = xbmcgui.DialogProgressBG()

PlotCashe={}
ImgCashe={}

#time.sleep(10)
#xbmc.sleep(5000)



print('----- Starting PLT_EPG -----')
start_trigger = True
#n=0
# =========================== Базовые функции ================================
def save_d(d):
	try:
		fp=xt(os.path.join(UserDir, 'epg.db'))
		fl = open(fp, "w")
		fl.write(repr(d))
		fl.close()
	except:
		pass

def get_d():
	try:
		fp=xt(os.path.join(UserDir, 'epg.db'))
		fl = open(fp, "r")
		d=eval(fl.read())
		fl.close()
		return d
	except:
		return {}

link_cnl = get_d()

def mfindal(http, ss, es):
	L=[]
	while http.find(es)>0:
		s=http.find(ss)
		#sn=http[s:]
		e=http.find(es)
		i=http[s:e]
		L.append(i)
		http=http[e+2:]
	return L

def b2s(s):
	if sys.version_info.major > 2:
		try:s=s.decode('utf-8')
		except: pass
		try:s=s.decode('windows-1251')
		except: pass
		#try:s=s.decode('cp437')
		#except: pass
		return s
	else:
		return s

def getURL2(url, dt=3):
		import requests
		try:
			s = requests.session()
			r=s.get(url, timeout=(0.5, dt), verify=False).text#0.00001
		except:
			print ('requests: timeout')
			r=''
		#r=r.encode('windows-1251')
		return r

def getURL(url, Referer = 'http://xbmc.ru/'):
	req = urllib2.Request(url)
	req.add_header('User-Agent', 'Opera/10.60 (X11; openSUSE 11.3/Linux i686; U; ru) Presto/2.6.30 Version/10.60')
	req.add_header('Accept', 'text/html, application/xml, application/xhtml+xml, */*')
	req.add_header('Accept-Language', 'ru,en;q=0.9')
	req.add_header('Referer', Referer)
	response = urllib2.urlopen(req)
	link=response.read()
	response.close()
	return b2s(link)


def get_HTML(url, post = None, ref = None, get_redirect = False):
    import urlparse
    if url.find('http')<0 :url='http:'+url
    request = urllib2.Request(url, post)

    host = urlparse.urlsplit(url).hostname
    if ref==None:
        try:
           ref='http://'+host
        except:
            ref='localhost'

    request.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
    request.add_header('Host',   host)
    request.add_header('Accept', 'text/html, application/xhtml+xml, */*')
    request.add_header('Accept-Language', 'ru-RU')
    request.add_header('Referer',             ref)
    request.add_header('Content-Type','application/x-www-form-urlencoded')

    try:
        f = urllib2.urlopen(request)
    except:
        return 'We failed to reach a server.'

    if get_redirect == True:
        html = f.geturl()
    else:
        html = f.read()

    return html




def ru(x):return unicode(x,'utf8', 'ignore')

def rt(x):
	try:
		L=[('&#133;','…'),('&#34;','&'), ('&#39;','’'), ('&#145;','‘'), ('&#146;','’'), ('&#147;','“'), ('&#148;','”'), ('&#149;','•'), ('&#150;','–'), ('&#151;','—'), ('&#152;','?'), ('&#153;','™'), ('&#154;','s'), ('&#155;','›'), ('&#156;','?'), ('&#157;',''), ('&#158;','z'), ('&#159;','Y'), ('&#160;',''), ('&#161;','?'), ('&#162;','?'), ('&#163;','?'), ('&#164;','¤'), ('&#165;','?'), ('&#166;','¦'), ('&#167;','§'), ('&#168;','?'), ('&#169;','©'), ('&#170;','?'), ('&#171;','«'), ('&#172;','¬'), ('&#173;',''), ('&#174;','®'), ('&#175;','?'), ('&#176;','°'), ('&#177;','±'), ('&#178;','?'), ('&#179;','?'), ('&#180;','?'), ('&#181;','µ'), ('&#182;','¶'), ('&#183;','·'), ('&#184;','?'), ('&#185;','?'), ('&#186;','?'), ('&#187;','»'), ('&#188;','?'), ('&#189;','?'), ('&#190;','?'), ('&#191;','?'), ('&#192;','A'), ('&#193;','A'), ('&#194;','A'), ('&#195;','A'), ('&#196;','A'), ('&#197;','A'), ('&#198;','?'), ('&#199;','C'), ('&#200;','E'), ('&#201;','E'), ('&#202;','E'), ('&#203;','E'), ('&#204;','I'), ('&#205;','I'), ('&#206;','I'), ('&#207;','I'), ('&#208;','?'), ('&#209;','N'), ('&#210;','O'), ('&#211;','O'), ('&#212;','O'), ('&#213;','O'), ('&#214;','O'), ('&#215;','?'), ('&#216;','O'), ('&#217;','U'), ('&#218;','U'), ('&#219;','U'), ('&#220;','U'), ('&#221;','Y'), ('&#222;','?'), ('&#223;','?'), ('&#224;','a'), ('&#225;','a'), ('&#226;','a'), ('&#227;','a'), ('&#228;','a'), ('&#229;','a'), ('&#230;','?'), ('&#231;','c'), ('&#232;','e'), ('&#233;','e'), ('&#234;','e'), ('&#235;','e'), ('&#236;','i'), ('&#237;','i'), ('&#238;','i'), ('&#239;','i'), ('&#240;','?'), ('&#241;','n'), ('&#242;','o'), ('&#243;','o'), ('&#244;','o'), ('&#245;','o'), ('&#246;','o'), ('&#247;','?'), ('&#248;','o'), ('&#249;','u'), ('&#250;','u'), ('&#251;','u'), ('&#252;','u'), ('&#253;','y'), ('&#254;','?'), ('&#255;','y'), ('&laquo;','"'), ('&raquo;','"'), ('&nbsp;',' '), ('&amp;quot;','"')]
		for i in L:
			x=x.replace(i[0], i[1])
		return x
	except:
		return x

def showMessage(heading, message, times = 3000):
	xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")'%(heading, message, times, icon))

def fs_enc(path):
    sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
    return path.decode('utf-8').encode(sys_enc)

def fs_dec(path):
    sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
    return path.decode(sys_enc).encode('utf-8')


def lower_old(t):
	try:
		RUS={"А":"а", "Б":"б", "В":"в", "Г":"г", "Д":"д", "Е":"е", "Ё":"ё", "Ж":"ж", "З":"з", "И":"и", "Й":"й", "К":"к", "Л":"л", "М":"м", "Н":"н", "О":"о", "П":"п", "Р":"р", "С":"с", "Т":"т", "У":"у", "Ф":"ф", "Х":"х", "Ц":"ц", "Ч":"ч", "Ш":"ш", "Щ":"щ", "Ъ":"ъ", "Ы":"ы", "Ь":"ь", "Э":"э", "Ю":"ю", "Я":"я"}
		for i in range (65,90):
			t=t.replace(chr(i),chr(i+32))
		for i in RUS.keys():
			t=t.replace(i,RUS[i])
	except: pass
	return t

def lower(t):
	RUS={"А":"а", "Б":"б", "В":"в", "Г":"г", "Д":"д", "Е":"е", "Ё":"ё", "Ж":"ж", "З":"з", "И":"и", "Й":"й", "К":"к", "Л":"л", "М":"м", "Н":"н", "О":"о", "П":"п", "Р":"р", "С":"с", "Т":"т", "У":"у", "Ф":"ф", "Х":"х", "Ц":"ц", "Ч":"ч", "Ш":"ш", "Щ":"щ", "Ъ":"ъ", "Ы":"ы", "Ь":"ь", "Э":"э", "Ю":"ю", "Я":"я"}
	for i in range (65,91):
		t=t.replace(chr(i),chr(i+32))
	for i in RUS.keys():
		t=t.replace(i,RUS[i])
	t=t.lower()
	return t


def upper(t):
	RUS={"А":"а", "Б":"б", "В":"в", "Г":"г", "Д":"д", "Е":"е", "Ё":"ё", "Ж":"ж", "З":"з", "И":"и", "Й":"й", "К":"к", "Л":"л", "М":"м", "Н":"н", "О":"о", "П":"п", "Р":"р", "С":"с", "Т":"т", "У":"у", "Ф":"ф", "Х":"х", "Ц":"ц", "Ч":"ч", "Ш":"ш", "Щ":"щ", "Ъ":"ъ", "Ы":"ы", "Ь":"ь", "Э":"э", "Ю":"ю", "Я":"я"}
	for i in RUS.keys():
		t=t.replace(RUS[i],i)
	for i in range (65,90):
		t=t.replace(chr(i+32),chr(i))
	return t

def CRC32(buf):
		import binascii
		if sys.version_info.major > 2: buf = (binascii.crc32(buf.encode('utf-8')) & 0xFFFFFFFF)
		else: buf = (binascii.crc32(buf) & 0xFFFFFFFF)
		r=str("%08X" % buf)
		return r

def mfind_old(t,s,e):
	r=t[t.find(s)+len(s):t.find(e)]
	return r

def mfind(t,s,e):
	r=t[t.find(s)+len(s):]
	r2=r[:r.find(e)]
	return r2
	
def debug(s):
	fl = open(ru(os.path.join( addon.getAddonInfo('path'),"test.txt")), "w")
	fl.write(s)
	fl.close()


# ================================ БД =======================================

def get_inf_db(cid):
	#print n
	if cid in link_cnl.keys(): cid=link_cnl[cid]
	#print n
	try: return EPG[cid]
	except: return {}


# ================================ EPG =======================================

def upepg():
	if __settings__.getSetting("epgon")=='true':
			pDialog.create('TV', 'Update EPG ...')
			pDialog.update(10, message='Clear EPG')
			clear_EPG()
			pDialog.update(50, message='Update EPG')
			#try: upd_EPG_xmltv()
			#except: pDialog.update(10, message='EPG: Error 1')
			#pDialog.update(70, message='Update EPG')
			try: upd_EPG_free()
			except: pDialog.update(10, message='EPG: Error 2')
			pDialog.update(90, message='Save EPG')
			save_EPG()
			#save_PICONS()
			pDialog.close()

def ADD_EPG(idx, De):
	#print '==== ADD_EPG '+idx
	if idx in EPG.keys():
		#print 'idx in EPG'
		cn=EPG[idx]
		for i in De.keys():
			if i in cn.keys() and i != 'title':
				#print 'i in cn'
				if De[i]["title"]!='': cn[i]["title"]=De[i]["title"]
				if De[i]["img"]!='':   cn[i]["img"] = De[i]["img"]
				if De[i]["plot"]!='':  cn[i]["plot"]= De[i]["plot"]
				if De[i]["type"]!='':  cn[i]["type"]= De[i]["type"]
			else:
				#print 'i not in cn'
				cn[i] = De[i]
		EPG[idx] = cn
	else:
		#print 'idx not in EPG'
		EPG[idx] = De

def get_nm_dict():
	nm_dict={}
	for i in EPG.keys():
		try:nm_dict[EPG[i]['title']]=i
		except:pass
	return nm_dict


def get_id(name):
	id = CRC32(lower(name))
	return id

#==============================   Старое ======================================

def POST(target, post=None, referer='http://torrentino.net'):
	#print target
	try:
		req = urllib2.Request(url = target, data = post)
		req.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
		req.add_header('X-Requested-With', 'XMLHttpRequest')
		req.add_header('Content-Type', 'application/x-www-form-urlencoded')
		resp = urllib2.urlopen(req)
		#print resp.info()
		http = resp.read()
		resp.close()
		return http
	except:
		print ('err post')
		return ''


def toutf(s):
	if sys.version_info.major > 2: return s
	s=eval('u"'+s.replace('"',"''")+'"')
	return s.encode('utf-8')

def add_picons_it999(i, channel_id):
			tmp = i.replace('<display-name','\n<display-name').replace('</display-name>','</display-name>\n')
			Lnm = tmp.splitlines()
			for n in Lnm:
				if '<display-name lang="ru">' in n:
					alt_name=n[n.find('<display-name lang="ru">')+24:n.find('</display-name>')]
					if 'lang=' in alt_name: alt_name='error'
					if alt_name!='error':
						alt_cid=get_id(alt_name)
						print (alt_name)
						print (alt_cid)
						cover = 'http://epg.it999.ru/img2/'+str(channel_id)+'.png'
						PICONS[alt_cid]=cover
						#change_id(alt_cid, cid)

def add_picons_korona():
	for key in CORPIC.keys():
		cid=get_id(key)
		PICONS[cid]=CORPIC[key]



def eval_u(inf):
	#print (inf)
	if sys.version_info.major > 2: 
		inf2 = 'b'+repr(inf).replace("\\\\x", "\\x")
		#print (inf2)
		info = eval(eval(inf2))##.replace("\\x", "\\\\x").replace("\\r", "\\\\r").replace("\\n", "\\\\n")
		#print (info)
	else:
		info = eval(inf)
	return info

def upd_EPG_free():
	import json 
	if sys.version_info.major > 2: 
		try: 
			d=json.loads(gzip.decompress(dload_epg_xml('http://193.124.130.96/epg/gzip')))
		except:
			try: 
				time.sleep(8)
				d=json.loads(gzip.decompress(dload_epg_xml('http://193.124.130.96/epg/gzip')))
			except:
				return
	else: 
		d=eval(dload_epg_xml('http://193.124.130.96/epg/dict'))
	for cid in d.keys():
		try:
			EPG[cid]=d[cid]
		except: 
			pass


def upd_EPG_free2():
	import json, gzip
	if sys.version_info.major > 2: 
		try: 
			d=json.loads(gzip.decompress(dload_epg_xml('http://193.124.130.96/epg/gzip')))
		except:
			try:
				time.sleep(3)
				d=json.loads(gzip.decompress(dload_epg_xml('http://193.124.130.96/epg/gzip')))
			except:
				return
	else: 
		d=json.loads(ram_ungz(dload_epg_xml('http://193.124.130.96/epg/gzip')))
	
	for cid in d.keys():
		De=d[cid]
		cn={}
		try:
			#print (De['title'])
			for i in De.keys():
				if i != 'title':
					cn[i]={}
					cn[i]["title"]=toutf(De[i]["title"])
					try:cn[i]["img"] = De[i]["img"]
					except: pass
					try:cn[i]["plot"]= toutf(De[i]["plot"])
					except:cn[i]["plot"] = ''
					try: cn[i]["type"] = toutf(De[i]["type"])
					except: cn[i]["type"] = ''
				else:
					cn[i] = toutf(De[i])
		except: 
			print ('err epg light cnl')
		Lc=cn.keys()
		if len(Lc)>2: EPG[cid] = cn



def upd_EPG_xmltv():
	print ("-==-=-=-=-=-=-=- upd_EPG_xmltv =-=-=-=-=-=-=-=-=-=-")
	xml=dload_epg_xml('http://epg.it999.ru/epg.xml')
	if xml!="":d=pars_xmltv_it999(xml)
	#xml=dload_epg_xml('http://free.tdwvt.keenetic.pro/epg/xmltv')#http://epg.korona-tv.top/999-light.xml
	#if xml!="": d=pars_xmltv(xml)


def dload_epg_xml(target=''):
	try:
			print ("-==-=-=-=-=-=-=- download =-=-=-=-=-=-=-=-=-=-")
			req = urllib2.Request(url = target, data = None)
			req.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
			resp = urllib2.urlopen(req, timeout=30)
			#return resp
			xml=b2s(resp.read())
			print ("-==-=-=-=-=-=-=- download ok=-=-=-=-=-=-=-=-=-=-")
			return xml
	except:
			print ('HTTP ERROR ')
			return ''

#upd_EPG_free()

def ungz(filename):
	import gzip
	with gzip.open(filename, 'rb') as f:
		file_content = f.read()
		f.close()
		return file_content


def pars_xmltv(xml):
	xml=xml.replace(chr(10),"").replace(chr(13),"").replace("<programme ", "\n<programme ").replace("<channel ", "\n<channel ")
	L=xml.splitlines()
	cdata = time.strftime('%Y%m%d')
	epg={}
	channel={}
	n=0
	for i in L:
		if "<channel " in i:
			channel_id=i[i.find('id="')+4:i.find('"><display')]
			if '"ru">' in i: name=i[i.find('"ru">')+5:i.find('</display-name>')]
			else: 			 name=i[i.find('<display-name>')+14:i.find('</display-name>')]
			#cid=channel_id.replace(':','_').replace(' ','_')#get_id(name)
			cid=get_id(name)
			channel[channel_id]={'id':cid, 'name':name}
		if "<programme " in i:
			n+=1
			if 'lang="ru">' in i: 
				title=i[i.find('<title lang="ru">')+17:i.find('</title>')]
				if 'desc' in i: desc=i[i.find('<desc lang="ru">')+16:i.find('</desc>')]
				else: desc=''
				if '<category' in i: cat=i[i.find('<category lang="ru">')+20:i.find('</category>')]
				else: cat=''
			else:
				title=i[i.find('<title>')+7:i.find('</title>')]
				if 'desc' in i: desc=i[i.find('<desc>')+6:i.find('</desc>')]
				else: desc=''
				if '<category' in i: cat=i[i.find('<category>')+10:i.find('</category>')]
				else: cat=''
			
			start_at=i[i.find('start="')+7:i.find(' +0')]
			ttv_id=i[i.find('channel="')+9:i.find('">')]
			cid=channel[ttv_id]['id']
			cnm=channel[ttv_id]['name']
			
			strptime=time.strptime(start_at , '%Y%m%d%H%M%S')
			tms=str(time.mktime(strptime)+10800)
			
			img=''
			
			if cid not in EPG.keys(): EPG[cid] = {'title':cnm}
			EPG[cid][tms]={"title":rt(title), 'img': img, 'plot': desc, 'type': cat}

def pars_xmltv_it999(xml):
	xml=xml.replace(chr(10),"").replace(chr(13),"").replace("<programme ", "\n<programme ").replace("<channel ", "\n<channel ").replace("&quot;", '"')
	L=xml.splitlines()
	xml=''
	cdata = time.strftime('%Y%m%d')
	epg={}
	channel={}
	n=0
	for i in L:
		if "<channel " in i:
			print ('---channel---')
			channel_id=i[i.find('id="')+4:i.find('">')]
			print(channel_id)
			name=i[i.find('<display-name lang="ru">')+24:i.find('</display-name>')]
			if 'lang=' in name: name='error'
			cid=get_id(name)
			#print (name)
			#print (cid)
			channel[channel_id]={'id':cid, 'name':name}
			#PICONS[cid]=channel_id
			add_picons_it999(i, channel_id)
		if "<programme " in i:
			n+=1
			title=i[i.find('<title lang="ru">')+17:i.find('</title>')]
			if '<category' in i: cat=i[i.find('<category>')+10:i.find('</category>')]
			else: cat=''
			if 'desc' in i: desc=i[i.find('<desc lang="ru">')+16:i.find('</desc>')]
			else: desc=cat
			
			start_at=i[i.find('start="')+7:i.find(' +0300')]
			ttv_id=i[i.find('channel="')+9:i.find('">')]
			cid=channel[ttv_id]['id']
			cnm=channel[ttv_id]['name']
			
			strptime=time.strptime(start_at , '%Y%m%d%H%M%S')
			tms=str(time.mktime(strptime))#+10800
			
			img=''
			if cnm!='error':
				if cid not in EPG.keys(): EPG[cid] = {'title':cnm}
				EPG[cid][tms]={"title":rt(title), 'img': img, 'plot': desc, 'type': cat}

def pars_xmltv3(xml):
	xml=xml.replace(chr(10),"").replace(chr(13),"").replace("<programme ", "\n<programme ").replace("<channel ", "\n<channel ")
	L=xml.splitlines()
	cdata = time.strftime('%Y%m%d')
	epg={}
	channel={}
	#epg_id=get_ttv_epg_id()
	n=0
	for i in L:
		if "<channel " in i:
			channel_id=i[i.find('id="')+4:i.find('"><display')]
			name=i[i.find('<display-name>')+14:i.find('</display-name>')]
			cid=get_id(name)
			#if cid not in EPG.keys(): EPG
			channel[channel_id]={'id':cid, 'name':name}
		if "<programme " in i:
			n+=1
			title=i[i.find('<title lang="ru">')+17:i.find('</title>')]
			if 'desc3' in i: desc=i[i.find('<desc lang="ru">')+16:i.find('</desc>')]
			else: desc=''
			if '<category' in i: cat=i[i.find('<category lang="ru">')+20:i.find('</category>')]
			else: cat=''
			
			start_at=i[i.find('start="')+7:i.find(' +0')]
			ttv_id=i[i.find('channel="')+9:i.find('">')]
			cid=channel[ttv_id]['id']
			cnm=channel[ttv_id]['name']
			
			strptime=time.strptime(start_at , '%Y%m%d%H%M%S')
			tms=str(time.mktime(strptime))
			
			img=''
			
			if cid not in EPG.keys(): EPG[cid] = {'title':cnm}
			EPG[cid][tms]={"title":rt(title), 'img': img, 'plot': desc, 'type': cat}

def pars_xmltv2(xml):
	xml=xml.replace(chr(10),"").replace(chr(13),"").replace("<programme ", "\n<programme ").replace("<channel ", "\n<channel ").replace("&quot;", '"')
	L=xml.splitlines()
	cdata = time.strftime('%Y%m%d')
	epg={}
	channel={}
	n=0
	for i in L:
		if "<channel " in i:
			channel_id=i[i.find('id="')+4:i.find('">')]
			name=i[i.find('<display-name>')+14:i.find('</display-name>')]
			cid=get_id(name)
			#if cid not in EPG.keys(): EPG
			channel[channel_id]={'id':cid, 'name':name}
		if "<programme " in i:
			n+=1
			title=i[i.find('<title>')+7:i.find('</title>')]
			if '<category' in i: cat=i[i.find('<category>')+10:i.find('</category>')]
			else: cat=''
			if 'desc' in i: desc=i[i.find('<desc>')+6:i.find('</desc>')]
			else: desc=cat

			start_at=i[i.find('start="')+7:i.find(' +0300')]
			ttv_id=i[i.find('channel="')+9:i.find('">')]
			cid=channel[ttv_id]['id']
			cnm=channel[ttv_id]['name']
			
			strptime=time.strptime(start_at , '%Y%m%d%H%M%S')
			tms=str(time.mktime(strptime))
			
			img=''
			
			if cid not in EPG.keys(): EPG[cid] = {'title':cnm}
			EPG[cid][tms]={"title":rt(title), 'img': img, 'plot': desc, 'type': cat}


# --------------------------------------------------
#upd_EPG_xmltv()
def clear_EPG():
	print ('clear_EPG')
	for cid in EPG.keys():
		cnl=EPG[cid]
		CL=[]
		try:CL2=cnl.keys()
		except:CL2=[]
		for c in CL2:
			CL.append(c)
		for tm in CL:
			if tm!='title':
				if time.time()-eval(tm) > 7*24*60*60:
					#print cid+' '+tm
					EPG[cid].pop(tm, '')

def debug_epg(cid):
	if cid in link_cnl.keys(): cid=link_cnl[cid]
	info=get_inf_db(cid)
	L=info.keys()
	print ("debug_epg " + info['title'])
	try:L.remove('title')
	except: pass
	L.sort()
	s=''
	for tm in L:
		t=time.ctime(eval(tm))
		ttl=info[tm]['title']
		si=t+" "+ttl
		print (si)
		s=s+si+'\n'
	return s


def change_id(cid1, cid2):
	print (cid1+' change_id_to '+cid2)
	if cid2 == '000000': link_cnl.pop(cid1, '')
	else: link_cnl[cid1]=cid2
	save_d(link_cnl)
	#info=get_inf_db(cid1)
	#EPG.pop(cid1, '')
	#EPG[cid2]=info
	#save_EPG()


def get_channels_info(cid):
	info=get_inf_db(cid)
	L=[]
	try:
		Lk=info.keys()
		for k in Lk:
			L.append(k)
	except:
		print ('info err:')
		print (info)
		return []
		
	try:L.remove('title')
	except: pass
	L.sort()
	if __settings__.getSetting('autoshift')=='true':
		dts=time.timezone 
	else:
		dts=(int(__settings__.getSetting('shift'))-11)*3600
	
	if __settings__.getSetting('DST_shift')=='true': dts -= time.localtime()[8]*3600
	#print dts
	ct=time.time()
	m_ct=ct+dts
	#print ct
	for i in L:
		#print i
		try:ei=eval(i)-3*60*60
		except:
			print ('!except eval(i)!')
			ei=0
		if ei > m_ct:
			#print 'ok'
			n1=L.index(i)
			n0=n1-1
			n2=n1+1
			e1=info[L[n1]]
			e1['time']=str(eval(L[n1])-3*60*60-dts)
			if n0>=0: 
				e0=info[L[n0]]
				e0['time']=str(eval(L[n0])-3*60*60-dts)
			else:e0={}
			if n2<len(L): 
				e2=info[L[n2]]
				e2['time']=str(eval(L[n2])-3*60*60-dts)
			else:e2={}
			Lr=[e0,e1,e2]
			#print Lr
			return Lr
	
	#if 'title' in info.keys():title=info['title']
	#else:title='Неизвестный канал'
	#print "NoEPG " +cid+' '+title
	return []

#get_channels_info('F79F4A92')
#print 'debug'
#debug_epg('7944E7D0')
#upepg()

def get_current_epg(ps='0'):
	print (ps)
	try:p=int(ps)
	except: p=0
	print ('run get_current_epg()')
	D={}
	n=0
	for cid in get_channels_list():
		if n>=(p-1)*100: 
			#print cid
			if cid!='udata':
				nfo=get_channels_info(cid)
				if cid in link_cnl.keys(): cid=link_cnl[cid]
				D[cid]=nfo
			if n > 0 and n >= 100*p: return D
		n+=1
	
	if D=={}:
		for cid in link_cnl.keys():
			id=link_cnl[cid]
			D[cid]=get_channels_info(id)

	return D

def get_all_current_epg():
	D={}
	for cid in get_channels_list():
			if cid!='udata': D[cid]=get_channels_info(cid)
				
	for cid in link_cnl.keys():
			id=link_cnl[cid]
			D[cid]=get_channels_info(id)
	return D


def get_channels_list():
	try:
		return EPG.keys()
	except: 
		print ('except: get_channels_list()')
		return []

def save_EPG():
		EPG['udata']=repr(time.time())#strftime('%Y%m%d')
		fp=xt(os.path.join(addon.getAddonInfo('path'), 'EPGdb.py'))
		try: fl = open(fp, "w", encoding="utf-8")
		except: fl = open(fp, "w")
		fl.write('# -*- coding: utf-8 -*-\n')
		fl.write('EPG={\n')
		for i in EPG.items():
			try: fl.write("'"+i[0]+"':"+repr(i[1])+',\n')#.encode('windows-1251').decode('utf-8')
			except: pass
		fl.write('}\n')
		fl.close()

def save_PICONS():
		fp=xt(os.path.join(addon.getAddonInfo('path'), 'PICONSdb.py'))
		try: fl = open(fp, "w", encoding="utf-8")
		except: fl = open(fp, "w")
		fl.write('# -*- coding: utf-8 -*-\n')
		fl.write('PICONS={\n')
		for key in PICONS.keys():
			try: fl.write("'"+key+"':'"+PICONS[key]+"',\n")#.encode('windows-1251').decode('utf-8')
			except: pass
		fl.write('}\n')
		fl.close()

#print get_current_epg()

import os
import socket
import time
import sys

def load_img(target):
	try:
			req = urllib2.Request(url = target, data = None)
			req.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
			resp = urllib2.urlopen(req)
			return resp.read()
	except:
			print ("err:  "+target)
			return None

def get_img(addres):
	try:
		if 's-tv.ru' in addres:
			#print 'stv img'
			if 'cid' in addres:
				cid=addres[addres.find('/cid')+4:addres.find('/tms')]
				tms=addres[addres.find('/tms')+4:addres.find('/program')]
				addres=addres[addres.find('/program'):]
			else:
				cid=''
			#print 'cid:'+cid
			url=addres.replace('/program/','http://')
			#print url
			http=getURL2(url, 5)
			if http=='': return ''
			img=mfind(http,'<img src="','" style=')
			#print img
			if cid!='':
				#print 'DESC'
				try:
					if '<h4>' in http: tmp1=xt(mfind(http,'<h4>','</h4>'))
					else:  tmp1=''
				except:
					print ('err tmp1')
					tmp1=''
				try:
					if 'ajax-info-desc' in http: tmp2=xt(mfind(mfind(http,'ajax-info-desc','<script type'),'<p>','</p>'))
					else: tmp2=''
				except:
					print ('err tmp2')
					tmp2=''
				
				if tmp1!='': desc=tmp1+"\n"+tmp2
				else: desc=tmp2
				#print xt(desc)
				if desc!="":
					EPG[cid][tms]['plot']=desc
		elif 'tv.mail.ru' in addres:
			#print 'stv img'
			if 'cid' in addres:
				cid=addres[addres.find('/cid')+4:addres.find('/tms')]
				tms=addres[addres.find('/tms')+4:addres.find('/program')]
				addres=addres[addres.find('/program'):]
			else:
				cid=''
			#print 'cid:'+cid
			url=addres.replace('/program/','http://')
			#print url
			http=getURL(url)
			if http=='': return ''
			import json
			j=json.loads(http)['tv_event']
			img=j['sm_image_url']
			#print img
			if cid!='':
				desc=toutf(j['descr'])
				#print xt(desc)
				if desc!="":
					EPG[cid][tms]['plot']=desc

		else:
			url='https://m.tv.yandex.ru'+addres.replace('/977/', '/146/')
			http=getURL(url)
			if http=='': return ''
			img='https://avatars.mds.yandex.net/get-tv-shows'+mfind(http,'//avatars.mds.yandex.net/get-tv-shows','"')
			img=img.replace('/small','/normal').replace('/large','/normal')
		return img
	except:
		return ''

from threading import Thread
class MyThread3(Thread):
	def __init__(self, param):
		Thread.__init__(self)
		self.param = param
	
	def run(self):
		exec(self.param)

def run_string(param):
		my_thread = MyThread3(param)
		my_thread.start()
#--------------------------------------------

def get_on(addres):
		print (addres)
		data=''
		if 'current' in addres:
			if '/p=' in addres: 
				p=addres[addres.find('/p=')+3:]
				data=repr(get_current_epg(p))
			else: 
				data=repr(get_all_current_epg())
			
		if  'debug' in addres:
			cid=addres[addres.rfind('/')+1:]
			data=debug_epg(cid)

		if  'update' in addres:
			data="update"
			#run_string('upepg()')
			upepg()
		
		if  'change/id' in addres:
			cid1=addres[addres.find('/id=')+4:addres.find('/to=')]
			cid2=addres[addres.find('/to=')+4:]
			data="change id"
			change_id(cid1, cid2)

		if  'channels' in addres:
			try:
				cid=addres[addres.rfind('/')+1:]
				#print cid
				if   cid == 'all':	data=repr(get_channels_list())
				elif cid =='dict':	data=repr(get_nm_dict())
				elif len(cid)>2:	data=repr(get_channels_info(cid))
				else: 				data="id:"+'None'
			except:
				print ("ERR EPG "+addres)
				data="ERR 404"
		
		if  'channel/full/id' in addres:
			cid=addres[addres.find('/id=')+4:]
			data=repr(get_inf_db(cid))
		
		if  'channel/json/dict' in addres:
			data=json.dumps(get_nm_dict())

		if  'channel/json/id' in addres:
			cid=addres[addres.find('/id=')+4:]
			if   cid == 'all':	data=json.dumps(EPG)
			else : 				data=json.dumps(get_inf_db(cid))
			
		if  'program' in addres:
			redir=get_img(addres)
			if redir=='': redir='http://kolomiets.by/wp-content/uploads/2016/03/error-768x432.jpg'
			if redir=='': data="ERR 404"
			else:         data=redir
		return data

# ================================ server =====================================

class HttpProcessor(BaseHTTPServer.BaseHTTPRequestHandler):
	
	def do_GET(self):
		data=get_on(self.path)
		
		if data == 'ERR 404':
			self.send_response(404)
		elif data[:4]=='http': 
			self.send_response(302)
			self.send_header('Location', data)
			self.send_header('content-type','image/jpeg')
		else:
			self.send_response(200)
			self.send_header('content-type','text/html')
		
		self.end_headers()
		
		try: data = data.encode()#'utf-8'
		except: pass

		self.wfile.write(data)
		if data == 'update': upepg()
		#quit_event.set()


#===================================================================
deb = True
port2 = 18189
trigger = True
LOG=[]
def LOG_append(t):
	try:
		if '/log/' not in t:
			tm=str(time.time())+' '
			LOG.append(tm+t)
			if len(LOG)>1000: LOG.pop(0)
	except: pass

def deb_print(s):
	if deb: print(s)
	LOG_append(s)

def get_on2(addres):
		global trigger
		data='ERR 404'
		if len(addres)>10: pref = addres[:10]
		else:              pref = addres
		if '/stop' in pref:
			trigger = False
			time.sleep(1)
			trigger = True
		if '/log/' in pref:
			data = ''
			for i in LOG:
				data +=i+'\n'
		elif 'restream/' in pref:
			trigger = False
			time.sleep(0.1)
			trigger = True
			data='BS:'+addres[addres.find('restream/')+9:]
		
		elif 'preload/' in pref:
			trigger = False
			time.sleep(0.1)
			trigger = True
			data='PL:'+addres[addres.find('preload/')+8:]

		elif 'status/' in pref:
			trigger = False
			time.sleep(0.1)
			trigger = True
			data='ST:'+addres[addres.find('status/')+7:]

		return data

headers_db={}

def get_streams(id):
		passw = str(__settings__.getSetting("passw"))
		pl_url = 'http://'+passw+'.tdwvt.keenetic.pro/streams/list/'+id
		L=eval(getURL(pl_url))
		return L

def alt_streams(id, n=0):
	L2=[]
	L=get_streams(id)
	if n>len(L)-1: n=-1
	addres=L[n]
	url=addres[addres.find('/udp/')+5:]
	for i in L:
		if url in i:
			L2.append(i)
	return L2

def get_sid(addres):
	sid=addres[addres.find('/stream/')+8:]
	deb_print(sid)
	return sid

# ================================ server =====================================
import bitstream
cbs=''
DBS={}
class HttpProcessor2(BaseHTTPServer.BaseHTTPRequestHandler):
	def do_HEAD(self):
		LOG_append('> HEAD')
		self.send_response(200)
		self.send_header('Content-type','video/octet-stream')
		self.end_headers()


	def do_POST(self):
		deb_print('> POST')
		deb_print(self.path)
		self.data_string = self.rfile.read(int(self.headers['Content-Length']))
		deb_print(self.data_string)
		LOG_append('> POST: '+self.path+' '+repr(self.data_string))
		set_headers(self.headers, self.path)
		
		addres = self.path
		data = ''
		post = None
		if 'proxy/' in addres:
			url=addres[addres.find('proxy/')+6:]
			post = self.data_string
			data = POST(url, post)
		elif 'http' in addres:
			post = self.data_string
			data = POST(addres, post)
		self.send_response(200)
		self.end_headers()
		LOG_append('< POST: '+str(len(data)))
		try: data = data.encode('utf-8')
		except: pass
		self.wfile.write(data)
	
	def do_GET(self):
		#try:
			try: xbmc.sleep(100)
			except: pass

			if 'Range:' in self.headers: 
				self.send_response(404)
				data = '404 Not Found'
				self.end_headers()
			deb_print('> GET: '+self.path)
			#deb_print('==============')
			#deb_print('\n'+str(self.headers))
			#deb_print('==============')
			
			data=get_on2(self.path)
			#LOG_append(data[:4])
			if data == 'ERR 404':
				self.send_response(404)
				self.end_headers()
			
			elif data[:3]=='PL:': 
				deb_print('== PL ==')
				curl=data[3:]
				deb_print(curl)
				SID=CRC32(curl)
				Lalt=alt_streams(get_sid(curl))
				deb_print(repr(Lalt))
				
				BS=bitstream.BS(curl, Lalt)
				deb_print ('connection: ok')
				DBS[SID]=BS
				self.send_response(200)
				self.end_headers()
				
				status = 0
				for i in range(24):
					status = BS.get_status()
					deb_print ('buffer: '+str(status))
					if status>0: break
					time.sleep(0.25)
				data = str(status)
			
			elif data[:3]=='ST:': 
				curl=data[3:]
				deb_print(curl)
				SID=CRC32(curl)
				self.send_response(200)
				self.end_headers()
				if SID in DBS.keys():
					BS=DBS[SID]
					status = BS.get_status()
					deb_print ('buffer: '+str(status))
					data = str(status)
				else: 
					data = "-1"
			
			elif data[:3]=='BS:': 
				#if 'bytes=0-' not in str(self.headers) : #'Kodi' in self.headers and 
				#	self.send_response(403)
				#	self.end_headers()
				#	self.wfile.write(b'')
				#	deb_print('Renturn 403')
				#	return None
				
				global cbs
				deb_print('== BS ==')
				curl=data[3:]
				deb_print(curl)
				
				'''
				if cbs==curl: 
					self.send_response(403)
					self.end_headers()
					self.wfile.close()
					#self.wfile.write(b'')
					deb_print('Renturn 403')
					return None
				'''
				
				cbs=curl
				#BS=BSc(curl)
				buf_sz = 500
				#import bitstream
				SID=CRC32(curl)
				if SID in DBS.keys(): 
					BS=DBS[SID]
					deb_print ('connection: DBS')
				else: 
					BS=bitstream.BS(curl)
					deb_print ('connection: ok')
					for i in range(24):
						status = BS.get_status()
						deb_print ('BS buffer: '+str(status))
						if status>=buf_sz: break
						time.sleep(0.25)
					
					if status<buf_sz/2:
						self.send_response(404)
						self.end_headers()
						self.wfile.write(b'')
						deb_print('Renturn 404')
						cbs=''
						return None
				
				self.send_response(200)
				#self.send_header('Content-type','video/octet-stream')
				self.send_header('Content-Type', 'video/mpeg')
				self.send_header('Accept-Ranges', 'bytes')
				self.send_header('Content-Ranges', 'bytes 0-9999999999999999')
				self.end_headers()
				
				deb_print('Renturn 200')
				
				bsn = 0
				bst = 0
				rs = 0
				while trigger:
					try: xbmc.sleep(1)
					except: time.sleep(0.0001)
					try:
						try: part=BS.get_data()
						except: part=None
						#if rs==0: 
						#	part = b'G'#part[752:]
						#	rs=1
						#	rs=0
						if part == 'error': break
						if part !=None: 
							try: self.wfile.write(part)
							except: 
								try: xbmc.sleep(100)
								except: pass
								break
							#print len(self.wfile)
							bsn = 0
						
						else: 
							print (bsn)
							if bsn > 1: break
							if bst > 15: break
							deb_print('== RECONNECT ==')
							try:BS.stop()
							except:pass
							#time.sleep(0.01)
							Lalt=alt_streams(get_sid(curl))
							BS=bitstream.BS(curl, Lalt)
							rs=1
							bsn+=1
							bst+=1
						
					except:
						break
				try: xbmc.sleep(100)
				except: pass
				
				BS.stop()
				try: xbmc.sleep(100)
				except: pass

				deb_print('== BS END ==')
				try: xbmc.sleep(500)
				except: time.sleep(0.5)
				cbs=''
				deb_print('== CBS END ==')
				return
			else:
				self.send_response(200)
				self.end_headers()
			if '/log/' not in self.path: LOG_append('< GET: '+str(len(data))+" "+ repr(data)[:6])
			
			try: data = data.encode('utf-8')
			except: pass
			self.wfile.write(data)
		#except:
		#	pass


class MyThreadingHTTPServer(SocketServer.ThreadingMixIn, BaseHTTPServer.HTTPServer):
	pass

#if __settings__.getSetting("epgon")=='true':
serv = MyThreadingHTTPServer(("localhost",port), HttpProcessor)
threading.Thread(target=serv.serve_forever).start()

serv2 = MyThreadingHTTPServer(("0.0.0.0",port2), HttpProcessor2)
threading.Thread(target=serv2.serve_forever).start()

print('----- PLT_EPG Запущен -----')
while not abortRequested():
		try:	udata = eval(get_inf_db('udata'))
		except: udata = 0
		cdata = time.time()#strftime('%Y%m%d')int()
		#print('----- PTV ud:'+str(udata))
		#print('----- PTV сd:'+str(cdata))
		try:ut=(int(__settings__.getSetting("updtime"))+1)*4
		except: ut=4
		print (ut)
		if cdata-udata>ut*60*60 and __settings__.getSetting("epgon")=='true':
			print('----- PLT_EPG обновление -----')
			upepg()
		
		for i in range(0, 10):
				xbmc.sleep(5000)
				if abortRequested():
					print ('----- PLT_EPG break -----')
					break


try:
	serv.shutdown()
	serv2.shutdown()
#try:s.close()
except:pass

print('----- PLT_EPG stopped -----')

