import sys
import xbmcaddon
from functions import *

ADDON = xbmcaddon.Addon()


def main():
    # Получаем строку с аргументами, переданными Коди нашему аддону
    # Игнорируем первый элемент (путь к скрипту) и
    # берем второй - номер локации (по умолчанию это ["1"]) или установка локации
    args = str(sys.argv[1])
    if args.startswith("location_search"):
        args = args[-1]
        handle_location_search(args)

    # Определяем сколько локаций, прописываем Location№
    determine_location()

    # Получаем из файла settings.xml значение локации
    # для парсера
    geoid = ADDON.getSetting(f'loc{args}_id')

    current_pogoda, daily_pogoda, hourly_pogoda = get_parse_weather(geoid)

    # Устанавливаем погоду в скин Коди
    set_weather(current_pogoda, daily_pogoda, hourly_pogoda, args)

if __name__ == "__main__":
    main()
