import requests
import hashlib
import random
import base64
import json

# Разбиение на блоки по 683 символа
chunk_size = 683
rp5_url = 'http://a.rp5.ru/i_n.php'
headers = {'User-Agent': 'Mozilla/5.0', 'Connection': 'Keep-Alive'}


def text_to_md5(in_str):
    md5_hash = hashlib.md5()
    md5_hash.update(in_str.encode('utf-8'))
    return md5_hash.hexdigest()


def text_to_base64(in_str):
    return base64.b64encode(in_str.encode('utf-8')).decode('utf-8').rstrip('=')


def base64_to_text(in_str):
    return base64.b64decode(in_str+'==').decode('utf-8')


def encode_rp5(in_str):
    chunks = [in_str[i:i+chunk_size] for i in range(0, len(in_str), chunk_size)]    
    return ''.join([text_to_base64(x[::-1]) for x in chunks])[::-1]


def decode_rp5(in_str):
    reversed_in_str = in_str[::-1]
    chunks = [reversed_in_str[i:i+chunk_size] for i in range(0, len(reversed_in_str), chunk_size)]
    return json.loads("".join([base64_to_text(x)[::-1] for x in chunks]))


def get_rp5_params(city_id):
    api = text_to_base64(city_id)
    city = encode_rp5(str(round(int(city_id)*3.141,3)))
    io = text_to_base64(text_to_md5(city)[::-1])[::-1]
    return api, city, io    


def get_weather(city_id, fields='fall'):
    api, city, io = get_rp5_params(city_id)
    # v6: поля a,f1,f3,f6,fall : обычно два поля "a,fall"
    # v2: поля a,f  : обычно два поля "a,f"
#    params = {'l': 'cnU', 'v': '2', 'fields': 'a,f', 'api': api, 'city': city, 'io': io}
    params = {'l': 'cnU', 'v': '6', 'fields': fields, 'api': api, 'city': city, 'io': io}
    response = requests.get(rp5_url, params=params,headers=headers).text
    return decode_rp5(response)['response']


def search_city(search_text):
    city_id = str(round((random.random() * 1000.0) + 1.0))
    api, city, io = get_rp5_params(city_id)
    params = {'l': 'cnU', 'v': '6', 's': search_text, 'api': api, 'city': city, 'io': io}
    response = requests.get(rp5_url, params=params,headers=headers).text
    return decode_rp5(response)


def get_phenomenon(ph):
    hints = {
        '': ['Без осадков','Преимущественно без осадков',],
        'rain': ['Слабый дождь','Умеренный дождь','Сильный дождь',],
        'snow': ['Слабый снег','Умеренный снег','Сильный снег',],
        'ice_rain': ['Слабый переохлаждённый дождь','Умеренный переохлаждённый дождь','Сильный переохлаждённый дождь',],
        'rain_snow': ['Слабый дождь со снегом','Умеренный дождь со снегом','Сильный дождь со снегом',],
        'snow_rain': ['Слабый снег с дождем','Умеренный снег с дождем','Сильный снег с дождем',],
    }
    return hints[ph['pr_type']][ph['pr_intensity']], ph['val_rain_mm'], ph['val_snow_mm'], ph['fogPosibility']


def get_wind_direction(hint_code):
    hints = ['Штиль','В','СВ','С','СЗ','З','ЮЗ','Ю','ЮВ']
    return hints[hint_code]


#print(get_weather('5483','a,fall'))
#print(search_city('Йошкар'))
